unit fSelectNote;

{
   Package: TIU - TEXT INTEGRATION UTILITIES 
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation 
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run. 
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ORCtrls, StdCtrls, uNote, ORFn, VA508AccessibilityManager, ExtCtrls;

type
  TfrmSelectNote = class(TForm)
    cmbNotes: TORComboBox;
    btnOK: TButton;
    btnCancel: TButton;
    VA508AccessibilityManager1: TVA508AccessibilityManager;
    pnlRightButtons: TPanel;
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmbNotesChange(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    function GetNotesByStatus(arItems:TNoteRecordArr;Pending:boolean):TNoteRecordArr;
  public
    { Public declarations }
  end;

const
  LLS_LINE2  = '^^____________________________________________________________________________';

var
  findTitle:string;
  preList:TNoteRecordArr;
  aftList:TNoteRecordArr;
  arList: TNoteRecordArr;
  iSplit:integer;
  ntSelected: TNoteRecord;
  frmSelectNote: TfrmSelectNote;

implementation

uses
  VA508AccessibilityRouter;

{$R *.DFM}

procedure TfrmSelectNote.btnCancelClick(Sender: TObject);
begin
  //Cancel selection
    ntSelected := nil;
  //Close
    Self.Close;
end;

procedure TfrmSelectNote.FormCreate(Sender: TObject);
var
  i:integer;
  strCap:string;
  ntItem:TNoteRecord;
  iIndex:integer;
begin
  //Default value
    iIndex := -1;
  //Have a list?
    if not assigned(arList) then
      begin
        ntSelected := nil;
        Self.Close;
      end;

  //Create Pre List
    preList := GetNotesByStatus(arList,True);
    aftList := GetNotesByStatus(arList,False);

  //Add the items
    if assigned(preList) then
    begin
      for i := Low(preList) to High(preList) do
        begin
          //Get the item
            ntItem := preList[i];
          //Generate our list text
            strCap := IntToStr(i) + '^p^Pending : ';
          //Now the Caption itself
            strCap := strCap + ntItem.Caption;
          //Add it
            cmbNotes.Items.Add(strCap);
            cmbNotes.Items.Objects[cmbNotes.Items.Count-1] := ntItem;
          //Selected?
            if (iIndex = -1) and (findTitle <> '') and (ntItem.Title = findTitle) then
              begin
                //Match.
                  iIndex := cmbNotes.Items.Count -1;
              end;
        end;
    end;


  //Add the div line
    iSplit := High(preList) +1;
  //Add the div line
    cmbNotes.Items.Add(LLS_LINE2);

  //Add the aft list items
    if assigned(aftList) then
    begin
      for i := Low(aftList) to High(aftList) do
        begin
          //Get the item
            ntItem := aftList[i];
          //Generate our list text
            strCap := IntToStr(i) + '^i^Imported : ';
          //Now the Caption itself
            strCap := strCap + ntItem.Caption;
          //Add it
            cmbNotes.Items.Add(strCap);
            cmbNotes.Items.Objects[cmbNotes.Items.Count-1] := ntItem;
        end;
    end;

  //Change the index?
    if iIndex > -1 then
      begin
        cmbNotes.ItemIndex := iIndex;
        cmbNotesChange(nil);
      end;
end;

procedure TfrmSelectNote.cmbNotesChange(Sender: TObject);
begin
  //Have an index?
    if cmbNotes.ItemIndex = -1 then
      begin
        ntSelected := nil;
        btnOK.Enabled := false;
        { TODO -oherb -c508 : Added Screen Reader Speak for 508 }
        GetScreenReader.Speak('No note selected.');
        Exit;
      end
    else
      begin
        ntSelected := TNoteRecord(cmbNotes.Items.Objects[cmbNotes.ItemIndex]);
        if not assigned(ntSelected) then
          begin
            btnOK.Enabled := False;
            { TODO -oherb -c508 : Added Screen Reader Speak for 508 }
            GetScreenReader.Speak('No note select.');
            Exit;
          end
        else
          begin
            btnOK.Enabled := True;
            { TODO -oherb -c508 : Added Screen Reader Speak for 508 }
            GetScreenReader.Speak( ntSelected.Caption );
          end;
      end;
end;

procedure TfrmSelectNote.btnOKClick(Sender: TObject);
begin
  //Close this form
    Self.Close;
end;

function tfrmSelectNote.GetNotesByStatus(arItems:TNoteRecordArr;Pending:boolean):TNoteRecordArr;
var
  i,l:integer;
  arRec:TNoteRecordArr;
  ntItem:TNoteRecord;
begin
   for l := Low(arItems) to High(arItems) do
    begin
      ntItem := arItems[l];
      if assigned(ntItem) then
        begin
          //Match what we're looking for?
            if not (ntItem.Imported = Pending) then
              begin
                //Yes.
                //Get the length
                  if(not assigned(arRec)) then
                    i := 0
                  else
                    i := Length(arRec);
                //Now resize our array and add the record item
                  SetLength(arRec,i+1);
                  arRec[i] := ntItem;
              end;
        end;
    end;
    Result := arRec;
end;

end.
